<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Login Form with OTP Verification</title>
<style>
    body {
        font-family: Arial, sans-serif;
        background-color: #f4f4f4;
    }
    .container {
        max-width: 400px;
        margin: 50px auto;
        padding: 20px;
        background-color: #fff;
        border-radius: 8px;
        box-shadow: 0px 0px 10px 0px rgba(0,0,0,0.1);
    }
    h2 {
        text-align: center;
    }
    input[type="text"],
    input[type="submit"] {
        width: 100%;
        padding: 10px;
        margin: 5px 0;
        border: 1px solid #ccc;
        border-radius: 5px;
        box-sizing: border-box;
    }
    input[type="submit"] {
        background-color: #4caf50;
        color: white;
        cursor: pointer;
    }
    input[type="submit"]:hover {
        background-color: #45a049;
    }
</style>
</head>
<body>

<div class="container">
    <h2>Login with OTP Verification</h2>
    <form id="loginForm" action="verify_otp.php" method="post">
        <label for="name">Name</label>
        <input type="text" id="name" name="name" required>
        <label for="mobile">Mobile No</label>
        <input type="text" id="mobile" name="mobile" required>
        <div id="otpInput" style="display: none;">
            <label for="otp">OTP</label>
            <input type="text" id="otp" name="otp" required>
        </div>
        <button id="otpButton" onclick="sendOTP()">Send OTP</button>
        <input type="submit" value="Submit">
    </form>
</div>

<script>
    function sendOTP() {
        var mobileNumber = document.getElementById('mobile').value;
        var xhr = new XMLHttpRequest();
        xhr.open('GET', 'send_otp.php?mobile=' + mobileNumber, true);
        xhr.onreadystatechange = function() {
            if (xhr.readyState == XMLHttpRequest.DONE) {
                if (xhr.status == 200) {
                    console.log("OTP Sent Successfully");
                    document.getElementById('otpInput').style.display = 'block'; // Show the OTP input field
                } else {
                    console.error("Error sending OTP");
                }
            }
        };
        xhr.send();
    }
</script>

</body>
</html>
