<?php
/*
Plugin Name: My Function Plugin
Plugin URI: http://www.rilah.com
Description: Append code to function.php on theme.
Author: Rilah Technologies
Version: 0.1
WC tested up to: 3.5.5
*/





// REMOVE META BOXES FROM WORDPRESS DASHBOARD FOR ALL USERS
 
function example_remove_dashboard_widgets()
{
    // Globalize the metaboxes array, this holds all the widgets for wp-admin
    global $wp_meta_boxes;
     
    unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_primary']);
    unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_secondary']);
    unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_plugins']);
    unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_incoming_links']);
    unset($wp_meta_boxes['dashboard']['normal']['core']['welcome-panel']);
}
add_action('wp_dashboard_setup', 'example_remove_dashboard_widgets' );


//remove left logo and etc from admin bar
function wps_admin_bar() {
    global $wp_admin_bar;
    $wp_admin_bar->remove_menu('wp-logo');
    $wp_admin_bar->remove_menu('about');
    $wp_admin_bar->remove_menu('wporg');
    $wp_admin_bar->remove_menu('documentation');
    $wp_admin_bar->remove_menu('support-forums');
    $wp_admin_bar->remove_menu('feedback');
}
add_action( 'wp_before_admin_bar_render', 'wps_admin_bar' );

//Remove unnecessary meta-data from your WordPress site
remove_action( 'wp_head', 'wp_generator' ) ; 
remove_action( 'wp_head', 'wlwmanifest_link' ) ; 
remove_action( 'wp_head', 'rsd_link' ) ;

//Disable HTML in WordPress comments
add_filter( 'pre_comment_content', 'wp_specialchars' );



// Function to change email address
 
function wpb_sender_email( $original_email_address ) {
    return 'info@webpoly.com';
}
 
// Function to change sender name
function wpb_sender_name( $original_email_from ) {
    return 'Webpoly';
}
 
// Hooking up our functions to WordPress filters 
add_filter( 'wp_mail_from', 'wpb_sender_email' );
add_filter( 'wp_mail_from_name', 'wpb_sender_name' );




// Rename WooCommerce to Shop
 
add_action( 'admin_menu', 'rename_woocoomerce', 999 );
 
function rename_woocoomerce()
{
    global $menu;
 
    // Pinpoint menu item
    $woo = rename_woocommerce( 'WooCommerce', $menu );
 
    // Validate
    if( !$woo )
        return;
 
    $menu[$woo][0] = 'Store Settings';
}
 
function rename_woocommerce( $needle, $haystack )
{
    foreach( $haystack as $key => $value )
    {
        $current_key = $key;
        if(
            $needle === $value
            OR (
                is_array( $value )
                && rename_woocommerce( $needle, $value ) !== false
            )
        )
        {
            return $current_key;
        }
    }
    return false;
}

add_filter( 'woocommerce_helper_suppress_admin_notices', '__return_true' );




// Change Login Logo 

function custom_login_logo() {
?>
<style type="text/css">
body.login div#login h1 a {
background-image: url('https://rilahweb.github.io/rilah_webUI.svg'); //Add the URL of your custom logo between the single quotes
padding-bottom: 30px;
}
</style>
<?php
} add_action( 'login_enqueue_scripts', 'custom_login_logo' );


// Change the Login Logo URL


add_filter( 'login_headerurl', 'custom_loginlogo_url' );
function custom_loginlogo_url($url) {
    return 'http://www.rilah.com';
}

add_filter( 'login_headertitle', 'custom_loginlogo_title' );
function custom_loginlogo_title($title) {
    return 'Powered by Rilah Technologies';
}



//Change WP login page title


function custom_login_title( $login_title ) {
return str_replace(array( ' &lsaquo;', ' &#8212; WordPress'), array( ' &bull;', ' &#8212; Rilah webUI'),$login_title );
}
add_filter( 'login_title', 'custom_login_title' );



//Admin pages title


function custom_admin_title( $admin_title ) {
return str_replace(array( ' &lsaquo;', ' &#8212; WordPress'), array( ' &bull;', ' &#8212; Rilah webUI'),$admin_title );
}
add_filter( 'admin_title', 'custom_admin_title' );





// Admin footer modification
  
function remove_footer_admin () 
{
    echo '<span id="footer-thankyou">Thank you for creating with <a href="http://www.rilah.com" target="_blank">Rilah webUI</a></span>';
}
add_filter('admin_footer_text', 'remove_footer_admin') ;



//Replace version message and theme name

function remove_version_message () 
{
    echo '<span id="wp-version-message">You are using <a href="http://www.rilah.com" target="_blank">Rilah webUI</a></span>';
}
add_filter('update_right_now_text', 'remove_version_message') ;





//Change the Howdy to Oh Yeah

add_action( 'admin_bar_menu', 'wp_admin_bar_my_custom_account_menu', 11 );
 
function wp_admin_bar_my_custom_account_menu( $wp_admin_bar ) {
$user_id = get_current_user_id();
$current_user = wp_get_current_user();
$profile_url = get_edit_profile_url( $user_id );
 
if ( 0 != $user_id ) {
/* Add the "My Account" menu */
$avatar = get_avatar( $user_id, 28 );
$howdy = sprintf( __('Oh Yeah, %1$s'), $current_user->display_name );
$class = empty( $avatar ) ? '' : 'with-avatar';
 
$wp_admin_bar->add_menu( array(
'id' => 'my-account',
'parent' => 'top-secondary',
'title' => $howdy . $avatar,
'href' => $profile_url,
'meta' => array(
'class' => $class,
),
) );
 
}
}


//webUI login css

function qot_login() {
echo '<link rel="stylesheet" href="https://rilahweb.github.io/rilah_webui_login.css">

</style>';
}
add_action('login_head', 'qot_login');


//webUI Support Rilah Backlink
function custom_link() { 
?><p style="text-align: center; margin-top: 1em;">
        <a style="color: ##555d66; text-decoration: none;" href="http://www.rilah.com/contact">If you have any query, Contact us</a>
    </p><?php 
}
add_action('login_footer','custom_link');




//Remove Dashboard Widget Wellcome and
function remove_dashboard_widgets() {
    global $wp_meta_boxes;
 
     
	remove_action('welcome_panel', 'wp_welcome_panel');
	 
	
}
 
add_action('wp_dashboard_setup', 'remove_dashboard_widgets' );





//Disable Admin Bar for All Users Except for Administrators

add_action('after_setup_theme', 'remove_admin_bar');
 
function remove_admin_bar() {
if (!current_user_can('administrator') && !is_admin()) {
  show_admin_bar(false);
}
}

/* Disable WordPress Admin Bar for all users but admins. 

  show_admin_bar(false); 
  */

/* Replace favicon from wordpress to default
*/
add_action( 'wp_head', 'prefix_favicon', 100 );
add_action( 'admin_head', 'prefix_favicon', 100 );
add_action( 'wp_head', 'prefix_favicon', 100 );
function prefix_favicon() {
    //code of the favicon logic
    ?>
        <link rel="icon" href="https://i.imgur.com/8z8a5eW.png">
    <?php
}
