<?php
// Start the output buffering
ob_start();
phpinfo();
$phpinfo = ob_get_contents();
ob_end_clean();

function get_loaded_extensions_info() {
    $extensions = get_loaded_extensions();
    $ext_info = [];
    foreach ($extensions as $ext) {
        $ext_info[$ext] = phpversion($ext) ?: 'unknown version';
    }
    return $ext_info;
}

function get_ini_settings() {
    $settings = ini_get_all();
    $ini_settings = [];
    foreach ($settings as $key => $value) {
        $ini_settings[$key] = $value['local_value'];
    }
    return $ini_settings;
}

function get_server_info() {
    return [
        'Server Software' => $_SERVER['SERVER_SOFTWARE'],
        'Server Protocol' => $_SERVER['SERVER_PROTOCOL'],
        'Document Root' => $_SERVER['DOCUMENT_ROOT'],
        'Remote Address' => $_SERVER['REMOTE_ADDR'],
        'Request URI' => $_SERVER['REQUEST_URI'],
        'Request Method' => $_SERVER['REQUEST_METHOD'],
        'Server Admin' => $_SERVER['SERVER_ADMIN'],
        'Server Name' => $_SERVER['SERVER_NAME'],
        'Server Address' => $_SERVER['SERVER_ADDR'],
    ];
}

$loaded_extensions_info = get_loaded_extensions_info();
$ini_settings = get_ini_settings();
$server_info = get_server_info();

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Advanced PHP Info</title>
    <style>
        body { font-family: Arial, sans-serif; }
        h1 { background-color: #f2f2f2; padding: 10px; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        table, th, td { border: 1px solid #ddd; }
        th, td { padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
    </style>
</head>
<body>
    <h1>Advanced PHP Information</h1>

    <h2>Server Information</h2>
    <table>
        <?php foreach ($server_info as $key => $value): ?>
            <tr>
                <th><?php echo htmlspecialchars($key); ?></th>
                <td><?php echo htmlspecialchars($value); ?></td>
            </tr>
        <?php endforeach; ?>
    </table>

    <h2>Loaded Extensions</h2>
    <table>
        <tr>
            <th>Extension</th>
            <th>Version</th>
        </tr>
        <?php foreach ($loaded_extensions_info as $ext => $version): ?>
            <tr>
                <td><?php echo htmlspecialchars($ext); ?></td>
                <td><?php echo htmlspecialchars($version); ?></td>
            </tr>
        <?php endforeach; ?>
    </table>

    <h2>INI Settings</h2>
    <table>
        <tr>
            <th>Setting</th>
            <th>Value</th>
        </tr>
        <?php foreach ($ini_settings as $setting => $value): ?>
            <tr>
                <td><?php echo htmlspecialchars($setting); ?></td>
                <td><?php echo htmlspecialchars($value); ?></td>
            </tr>
        <?php endforeach; ?>
    </table>

    <h2>PHP Info</h2>
    <div>
        <?php echo $phpinfo; ?>
    </div>
</body>
</html>
